/*
 * Decompiled with CFR 0.152.
 */
package com.smardec.mousegestures;

import com.smardec.mousegestures.MouseGestures;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

class MouseGesturesRecognizer {
    private static final String LEFT_MOVE = "L";
    private static final String RIGHT_MOVE = "R";
    private static final String UP_MOVE = "U";
    private static final String DOWN_MOVE = "D";
    private int gridSize = 30;
    private MouseGestures mouseGestures;
    private Point startPoint = null;
    private StringBuffer gesture = new StringBuffer();

    MouseGesturesRecognizer(MouseGestures mouseGestures) {
        this.mouseGestures = mouseGestures;
    }

    void processMouseEvent(MouseEvent mouseEvent) {
        if (!(mouseEvent.getSource() instanceof Component)) {
            return;
        }
        Point mouseEventPoint = mouseEvent.getPoint();
        SwingUtilities.convertPointToScreen(mouseEventPoint, (Component)mouseEvent.getSource());
        if (this.startPoint == null) {
            this.startPoint = mouseEventPoint;
            return;
        }
        int deltaX = this.getDeltaX(this.startPoint, mouseEventPoint);
        int deltaY = this.getDeltaY(this.startPoint, mouseEventPoint);
        int absDeltaX = Math.abs(deltaX);
        int absDeltaY = Math.abs(deltaY);
        if (absDeltaX < this.gridSize && absDeltaY < this.gridSize) {
            return;
        }
        float absTangent = (float)absDeltaX / (float)absDeltaY;
        if (absTangent < 1.0f) {
            if (deltaY < 0) {
                this.saveMove(UP_MOVE);
            } else {
                this.saveMove(DOWN_MOVE);
            }
        } else if (deltaX < 0) {
            this.saveMove(LEFT_MOVE);
        } else {
            this.saveMove(RIGHT_MOVE);
        }
        this.startPoint = mouseEventPoint;
    }

    private int getDeltaX(Point a, Point b) {
        return b.x - a.x;
    }

    private int getDeltaY(Point a, Point b) {
        return b.y - a.y;
    }

    private void saveMove(String move) {
        if (this.gesture.length() > 0 && this.gesture.charAt(this.gesture.length() - 1) == move.charAt(0)) {
            return;
        }
        this.gesture.append(move);
        this.mouseGestures.fireGestureMovementRecognized(this.getGesture());
    }

    int getGridSize() {
        return this.gridSize;
    }

    void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    String getGesture() {
        return this.gesture.toString();
    }

    boolean isGestureRecognized() {
        return this.gesture.length() > 0;
    }

    void clearTemporaryInfo() {
        this.startPoint = null;
        this.gesture.delete(0, this.gesture.length());
    }
}

